/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CellInput;
import java.io.IOException;
import java.io.InputStream;

final class CellBufferInputStream
extends InputStream
implements CellInput {
    private byte[] buf = null;
    private int pos = 0;
    private int mark = 0;
    private int count = 0;
    private char[] char_buffer = new char[8192];

    CellBufferInputStream() {
    }

    void setArray(byte[] new_buffer) {
        this.buf = new_buffer;
        this.pos = 0;
        this.mark = 0;
        this.count = new_buffer.length;
    }

    void setArray(byte[] new_buffer, int offset, int length) {
        this.buf = new_buffer;
        this.pos = offset;
        this.mark = 0;
        this.count = Math.min(new_buffer.length, length + offset);
    }

    public int read() {
        return this.buf[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public int available() {
        return this.count - this.pos;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void close() throws IOException {
    }

    public void readFully(byte[] b) throws IOException {
        this.read(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.read(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    public short readShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readUnsignedShort() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (ch1 << 8) + (ch2 << 0);
    }

    public char readChar() throws IOException {
        int ch1 = this.read();
        int ch2 = this.read();
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    public String readChars(int length) throws IOException {
        if (length <= this.char_buffer.length) {
            for (int i = 0; i < length; ++i) {
                this.char_buffer[i] = (char)(((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 0));
            }
            return new String(this.char_buffer, 0, length);
        }
        StringBuffer chrs = new StringBuffer(length);
        for (int i = length; i > 0; --i) {
            chrs.append((char)(((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 0)));
        }
        return new String(chrs);
    }

    public int readInt() throws IOException {
        return ((this.buf[this.pos++] & 0xFF) << 24) + ((this.buf[this.pos++] & 0xFF) << 16) + ((this.buf[this.pos++] & 0xFF) << 8) + ((this.buf[this.pos++] & 0xFF) << 0);
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        throw new Error("Not implemented.");
    }

    public String readUTF() throws IOException {
        throw new Error("Not implemented.");
    }
}

